// AIStpCmdDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AIStpCmd.h"
#include "AIStpCmdDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAIStpCmdDlg dialog

CAIStpCmdDlg::CAIStpCmdDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAIStpCmdDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAIStpCmdDlg)
	m_statusLabel = _T("");
	m_devNum = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAIStpCmdDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAIStpCmdDlg)
	DDX_Control(pDX, IDC_STOP, m_stopButton);
	DDX_Control(pDX, IDC_START, m_startButton);
	DDX_Control(pDX, IDC_LIST1, m_ListBoxData);
	DDX_Text(pDX, IDC_STATUS, m_statusLabel);
	DDX_Text(pDX, IDC_DEV_NUM, m_devNum);
	DDV_MinMaxUInt(pDX, m_devNum, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAIStpCmdDlg, CDialog)
	//{{AFX_MSG_MAP(CAIStpCmdDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAIStpCmdDlg message handlers

BOOL CAIStpCmdDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAIStpCmdDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAIStpCmdDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAIStpCmdDlg::OnStart() 
{
	// Setup a Stop on Command, paced AI task

	/*  When the sampling duration is indeterminate, e.g. stop on command or stop on
	    trigger, some rules on buffering must be observed:

        Use at least 3 buffers.  Total buffering should approximate 1 second worth of data.
	    If too few buffers are specified, then DataLost message can result.

        Combination of buffer size and sample rate will determine the rate at which
	    buffer filled messages are sent to the application.  Don't structure the buffers such
	    that Windows message queue is asked to run too fast (not faster than 10msec repeat rate).
      */
	m_startButton.EnableWindow(FALSE); //Disable the start button 

	clearBuffers();	//de-allocate any exisiting buffers in the service request

	m_pSR->operation=START; //Start the acquisition
	m_pSR->subsystem=AI; //using the AI subsystem
	m_pSR->mode=INTERRUPT; //use interrupt mode...could be DMA if your board supports DMA mode
	m_pSR->start.typeEvent=COMMAND; //Start on command
	m_pSR->timing.typeEvent=RATEEVENT; //timing will be determined by the rate generator
	m_pSR->stop.typeEvent=COMMAND; //Stop on command
	m_pSR->channels.nChannels=2; //A start/stop channel range will be used
	m_pSR->channels.chanGain[0].channel=m_logicalChannel; //starting channel defined by m_logicalChannel
	m_pSR->channels.chanGain[0].gainOrRange=Gain2Code(m_logicalDevice,AI,-1.0); //Use bipolar unity gain
    m_pSR->channels.chanGain[1].channel=m_logicalChannel+7;  // stop on chan 7
	m_pSR->channels.chanGain[1].gainOrRange=Gain2Code(m_logicalDevice,AI,-1.0);
	m_pSR->channels.numberFormat=tNATIVE; //use the native format (integer counts)
	/*  Declare three buffers  */
	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(3)]; //create a buffer list pointer for 3 buffers
	m_pSR->lpBuffers->notify=NOTIFY; //enable the buffer filled message
	m_pSR->lpBuffers->nBuffers=3; //use three buffers
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_logicalDevice,AI,m_logicalChannel,m_samples); //set the size of the buffer (in bytes) to hold the number of samples
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified
	m_pSR->lpBuffers->BufferAddr[1]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize);
	m_pSR->lpBuffers->BufferAddr[2]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize);

	/* the rate information for the RATEEVENT typeEvent */
	m_pSR->timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER is a symbol representing the default counter/timer channel used for pacing.
	m_pSR->timing.u.rateEvent.mode=RATEGEN; //Set the counter/timer mode to rate mode
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;  //Internal clocking will be used
	m_pSR->timing.u.rateEvent.gate=DISABLED; //no gating will be used
	m_pSR->timing.u.rateEvent.period=Sec2Tics(m_logicalDevice,AI,INTERNAL1,0.1f); //10 Hz
	if (DriverLINX(m_pSR) == NoErr)  //Execute the service request to start the acquisition
	{  	// success
     	m_task=m_pSR->taskId; //Need to save the task ID of the AI task so it can be stopped later
	m_stopButton.EnableWindow(TRUE);  // enable the Stop button
	m_startButton.EnableWindow(FALSE);  // disable the Start button
	/*See the WindowProc function to see what happens next*/
	 }
else  // problem has occured
{  showMessage(m_pSR);}  // display the error message box	
	
}  //OnStart

void CAIStpCmdDlg::OnStop() 
{
	// stop the active AI task
    m_pSR->taskId=m_task;  // restore the task ID
    m_pSR->operation=STOP;
	m_pSR->start.typeEvent=NULLEVENT;
	m_pSR->mode=INTERRUPT;   // could be DMA mode if board has that feature
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	m_startButton.EnableWindow(TRUE);
	m_stopButton.EnableWindow(FALSE);

	
}

void CAIStpCmdDlg::OnInit() 
{
   // get the Device Number from the Dialog
	UpdateData(TRUE);  // this will refresh the m_devNum variable
    m_logicalDevice = m_devNum;  //Set for the DriverLINX logical device being used
	m_pSR=NULL;
	m_driverInstance=NULL;
	m_logicalChannel=0; //Use channel 0 by default
	m_samples=8; //Set the number of samples to acquire here
	// the buffer size MUST be a multiple of the number of channels
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //need to register DriverLINX messages to detect buffer filled message
	// pass in driver name to avoid the Open DriverLINX dialog
	m_driverInstance=OpenDriverLINX(m_hWnd,"kmb1800"); //Open DriverLINX driver
	// give driver name to avoid the dialog box; use kmb1700 for DAS-1700
	m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
	DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
	m_pSR->device=m_logicalDevice; //set the device number to the device being used
	m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
	m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
	m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
	m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
	if (DriverLINX(m_pSR) == NoErr)
	{  	// success
      m_startButton.EnableWindow(TRUE);  // enable the Start button
      // Initialize our DriverLINX variables
   	 m_samples = 8;        // how many samples
   	 m_logicalChannel = 0; // starting channel
	 }
else  // problem has occured
{  showMessage(m_pSR);}  // display the error message box

// set focus back to our dialog
CWnd::SetActiveWindow();

}

void CAIStpCmdDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAIStpCmdDlg::clearBuffers()
{
	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(m_pSR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(m_pSR->lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to a buffer?*/
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
				// clear the other two buffers as well that this example uses
                BufFree(m_pSR->lpBuffers->BufferAddr[1]);
				m_pSR->lpBuffers->BufferAddr[1]=NULL;
				BufFree(m_pSR->lpBuffers->BufferAddr[2]);
				m_pSR->lpBuffers->BufferAddr[2]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(m_pSR->lpBuffers); 
			m_pSR->lpBuffers=NULL;
		}
	}
}


void CAIStpCmdDlg::OnClose() 
{
	// clean up after DriverLINX
	clearBuffers(); //de-allocate any existing buffers
	CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
	m_driverInstance=NULL; //for safety, make sure m_driverInstance isn't pointing to anything
	delete(m_pSR); //de-allocate the memory used by the service request
	m_pSR=NULL;
	// pass it on
	CDialog::OnClose();
}

LRESULT CAIStpCmdDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
		if(message==m_DLmsg) //Did DriverLINX post a message?  We only want to act on the DriverLINX buffer filled message
	{
		switch(wParam)
		{
		case DL_BUFFERFILLED: //Was the DriverLINX message the buffer filled message?
			// determine the index of the buffer that if full
			m_bufnum=getBufIndex(lParam); //Get index of the full buffer
			done(m_bufnum); //if so, call the done() function to process the results
			break;
		case DL_DATALOST:
			// call a handler for this condition
			break;
		case DL_SERVICEDONE:
            m_statusLabel.Format("%s","The task is now inactive.");
	        UpdateData(FALSE); //Update the listbox display
			break;
		}
	}
	return CDialog::WindowProc(message, wParam, lParam);
}

void CAIStpCmdDlg::done(int bufNum)
{
	float *readings;
	readings = new float[m_samples]; //make a temporary array to hold the converted readings
	CString str; //The CString class includes a format method to convert float to CString to display them in the listbox
	char chanIndex[30],bufIndex[30];
	int index;
	/*The convert operation used here is taking advantage of the fact
	that the logical device number and the subsystem (AI) have already
	been set in the start request*/
	m_pSR->operation=CONVERT; //Use the convert operation to convert the raw counts in the buffer to voltages
	m_pSR->mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
	m_pSR->start.typeEvent=DATACONVERT; //Set the start type to convert the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
	m_pSR->start.u.dataConvert.nSamples=m_samples; //set the number of samples to convert
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=bufNum; //
	m_pSR->start.u.dataConvert.lpBuffer=readings; //put the converted readings in the temporary buffer
	DriverLINX(m_pSR); //Execute the conversion
	showMessage(m_pSR); //show any errors
	m_ListBoxData.ResetContent(); //clear the listbox
	for(index=0;index<m_samples;index++)
	{
       strcpy(chanIndex,"chan #: ");
	   str.Format("%d",index);
	   strcat(chanIndex,str);  
       strcat(chanIndex," ");  // build a string of indexed chans
	   str.Format("%8.3f",readings[index]); //format the float reading into a string for each reading
	   strcat(chanIndex,str);  // add the reading onto end
	   m_ListBoxData.AddString(chanIndex); //Add the string to the listbox
	}
	strcpy(bufIndex,"Buffer number is: ");
	str.Format("%d",bufNum);
	strcat(bufIndex,str);
	m_statusLabel.Format("%s",bufIndex);
	UpdateData(FALSE); //Update the listbox display
	delete [] readings; //clear the temporary buffer so we don't have memory leaks when we run it again
}
